/*
 * #%L
 * Wildfly Camel :: Testsuite
 * %%
 * Copyright (C) 2013 - 2017 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.wildfly.camel.test.spring.subE.servlet;

import java.io.IOException;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.camel.CamelContext;

@WebServlet(name = "HttpServiceServlet", urlPatterns = { "/*" }, loadOnStartup = 1)
public class MultipleResourceInjectionServlet extends HttpServlet {

    @Resource(lookup = "java:jboss/camel/context/jndi-delayed-binding-spring-context")
    private CamelContext camelctxA;

    @Resource(mappedName = "java:jboss/camel/context/jndi-delayed-binding-spring-context")
    private CamelContext camelctxB;

    @Resource(name = "java:jboss/camel/context/jndi-delayed-binding-spring-context")
    private CamelContext camelctxC;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

        if (camelctxA != null) {
            response.getOutputStream().print("camelctxA,");
        }

        if (camelctxB != null) {
            response.getOutputStream().print("camelctxB,");
        }

        if (camelctxC != null) {
            response.getOutputStream().print("camelctxC");
        }
    }
}
