
## Azure

https://portal.azure.com

Email: fuse.wfc.ci@gmail.com

Create blob storage account
    - Resource Group: FuseCI
    - Storage account name: camelblob
    - Account kind: BlobStorage
    - Replication: LRS
    - Blob access tier: Hot
    
    export AZURE_STORAGE_BLOB_ACCOUNT=camelblob
    export AZURE_STORAGE_BLOB_KEY=xxx

Create queue storage account
    - Resource Group: FuseCI
    - Storage account name: camelqueue
    - Account kind: StorageV2
    - Replication: LRS
    - Blob access tier: Hot
    
    export AZURE_STORAGE_QUEUE_ACCOUNT=camelqueue
    export AZURE_STORAGE_QUEUE_KEY=xxx

## Box

https://app.box.com/developers/console

Email: fuse.wfc.ci@gmail.com

1) Create a Custom App with OAuth 2.0 Authentication

    export BOX_USERNAME=fuse.wfc.ci@gmail.com
    export BOX_PASSWORD=xxx
    export BOX_CLIENT_ID=xxx
    export BOX_CLIENT_SECRET=xxx

## Braintree

https://sandbox.braintreegateway.com

Email: fuse.wfc.ci@gmail.com
Username: fuseci

    export CAMEL_BRAINTREE_ENVIRONMENT=SANDBOX
    export CAMEL_BRAINTREE_MERCHANT_ID=xxx
    export CAMEL_BRAINTREE_PUBLIC_KEY=xxx
    export CAMEL_BRAINTREE_PRIVATE_KEY=xxx

## DigitalOcean

https://developers.digitalocean.com/documentation/oauth/

Email: fuse.wfc.ci@gmail.com

1) Register a new OAuth application
    Name: FuseCI
    Homepage URL: https://github.com/wildfly-extras/wildfly-camel
    Callback URL: https://postman-echo.com/get

    export DIGITALOCEAN_CLIENT_ID=xxx
    export DIGITALOCEAN_CLIENT_SECRET=xxx
    
    echo "https://cloud.digitalocean.com/v1/oauth/authorize?client_id=$DIGITALOCEAN_CLIENT_ID
        &redirect_uri=https://postman-echo.com/get
        &response_type=code&scope=read%20write"
    
    export DIGITALOCEAN_CLIENT_CODE=xxx
    
    curl -X POST "https://cloud.digitalocean.com/v1/oauth/token?grant_type=authorization_code
        &client_id=$DIGITALOCEAN_CLIENT_ID&client_secret=$DIGITALOCEAN_CLIENT_SECRET
        &redirect_uri=https://postman-echo.com/get"
        &code=$DIGITALOCEAN_CLIENT_CODE
    
    export DIGITALOCEAN_OAUTH_TOKEN=xxx

## Docker Registry

    export DOCKER_JAVA_REGISTRY_USERNAME=yourname
    export DOCKER_JAVA_REGISTRY_PASSWORD=yourpass

## Google API

https://console.developers.google.com

Email: fuse.wfc.ci@gmail.com

Setting up OAuth 2.0
https://support.google.com/googleapi/answer/6158849?hl=en&ref_topic=7013279

1) Go to the API Console.
2) From the projects list, select a project or create a new one.
3) If the APIs & services page isn't already open, open the console left side menu and select APIs & services.
4) On the left, click Credentials.
5) Click New Credentials, then select OAuth client ID. 
6) Select the appropriate application type for your project and enter any additional information required. 
7) If this is your first time creating a client ID, you can also configure your consent screen by clicking Consent Screen.
    Application name: Application name
    Support email: fuse.wfc.ci@gmail.com
    Scopes for Google APIs
        https://mail.google.com
        https://www.googleapis.com/auth/calendar.events
        https://www.googleapis.com/auth/calendar
        https://www.googleapis.com/auth/drive
        https://www.googleapis.com/auth/pubsub   
8) Create OAuth client ID
    Application type: Web application
    Name: Fuse WFC Testsuite Client
    Authorized redirect URIs: https://developers.google.com/oauthplayground
9) [Authorize APIs](https://developers.google.com/oauthplayground)
    Setting | Use your own OAuth credentials
    
    Calendar API v3 `https://www.googleapis.com/auth/calendar`
    Drive API v3 `https://www.googleapis.com/auth/drive`
    Gmail API v1 `https://mail.google.com`
    Pub/Sub API v1 `https://www.googleapis.com/auth/pubsub`
    
    export GOOGLE_API_APPLICATION_NAME="Fuse WFC Testsuite"
    export GOOGLE_API_CLIENT_ID=xxx.apps.googleusercontent.com
    export GOOGLE_API_CLIENT_SECRET=xxx
    export GOOGLE_API_REFRESH_TOKEN=xxx

10) Refresh access token 

GOOGLE_API_ACCESS_TOKEN=$(curl -sX POST https://oauth2.googleapis.com/token \
   -d "client_id=$GOOGLE_API_CLIENT_ID&client_secret=$GOOGLE_API_CLIENT_SECRET&refresh_token=$GOOGLE_API_REFRESH_TOKEN&grant_type=refresh_token" | jq .access_token) \
   && echo "GOOGLE_API_ACCESS_TOKEN=$GOOGLE_API_ACCESS_TOKEN"

Test Calendar access 

    curl https://www.googleapis.com/calendar/v3/users/me/calendarList \
      --header "Authorization: Bearer $GOOGLE_API_ACCESS_TOKEN"

Test GMail access 

    curl https://gmail.googleapis.com/gmail/v1/users/fuse.wfc.ci@gmail.com/messages \
      --header "Authorization: Bearer $GOOGLE_API_ACCESS_TOKEN"

Test PubSub access

    curl https://pubsub.googleapis.com/v1/projects/wfc-testsuite-10258/topics \
      --header "Authorization: Bearer $GOOGLE_API_ACCESS_TOKEN"
      
## Google PubSub via Service Account

https://console.cloud.google.com/iam-admin/serviceaccounts?project=wfc-testsuite-10258

https://cloud.google.com/pubsub/docs/reference/libraries#setting_up_authentication

Currently we use GooglePubsubConnectionFactory, which does not support the OAuth authentication from above.
Instead, PubSub recommends to use a Service Account

## IPStack

https://ipstack.com

Email: fuse.wfc.ci@gmail.com

    export GEOLOCATION_ACCESS_KEY=xxx
    
## Nexus

Needed to download SAP libraries from Nexus

    export NEXUS_USER=hudson
    export NEXUS_PASSWORD=xxx

## Openweather

https://openweathermap.org

Email: fuse.wfc.ci@gmail.com

    export OPENWEATHER_APP_ID=xxx

curl "http://api.openweathermap.org/data/2.5/weather?q=London,uk&appid=$OPENWEATHER_APP_ID"

## Salesforce

https://developer.salesforce.com

Email: fuse.wfc.ci@gmail.com

https://eu13.lightning.force.com/lightning/setup

https://help.salesforce.com/articleView?id=connected_app_create_api_integration.htm
https://help.salesforce.com/articleView?id=remoteaccess_oauth_username_password_flow.htm

   Note, when using the username-password flow with an API, create a field in the username and password login screen where users can enter 
   their security token. The security token is an automatically generated key that must be added to the end of the password to log in to 
   Salesforce from an untrusted network. Concatenate the password and token when passing the request for authentication.
   
Note, I found that spcial chars in the password (i.e. $ @) may be cause authorization to fail.
Other than documented above, the security code does not need to be appended to password.

    export SALESFORCE_CONSUMER_KEY=xxx
    export SALESFORCE_CONSUMER_SECRET=xxx
    export SALESFORCE_USER=fuse.wfc.ci@gmail.com
    export SALESFORCE_PASSWORD=xxx

curl \
--data "client_id=$SALESFORCE_CONSUMER_KEY" \
--data "client_secret=$SALESFORCE_CONSUMER_SECRET" \
--data "username=$SALESFORCE_USER" \
--data "password=$SALESFORCE_PASSWORD" \
--data "grant_type=password" \
https://login.salesforce.com/services/oauth2/token

## Servicenow

https://developer.servicenow.com

https://docs.servicenow.com/bundle/paris-application-development/page/integrate/inbound-rest/task/t_EnableOAuthWithREST.html

Email: fuse.wfc.ci@gmail.com

1) Create a [developer instance](https://dev94968.service-now.com)
2) Create an OAuth API endpoint for external clients

    export SERVICENOW_INSTANCE=dev94968
    export SERVICENOW_USERNAME=admin
    export SERVICENOW_PASSWORD=xxx
    export SERVICENOW_CLIENT_ID=xxx
    export SERVICENOW_CLIENT_SECRET=xxx

curl -X POST -d "grant_type=password&client_id=$SERVICENOW_CLIENT_ID&client_secret=$SERVICENOW_CLIENT_SECRET&username=$SERVICENOW_USERNAME&password=$SERVICENOW_PASSWORD" https://$SERVICENOW_INSTANCE.service-now.com/oauth_token.do

## Twilio

https://www.twilio.com/console/project/settings

Email: fuse.wfc.ci@gmail.com

    export TWILIO_ACCOUNT_SID=xxx
    export TWILIO_AUTH_TOKEN=xxx

