/*
    Copyright (C) 2017 Red Hat, Inc.

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

            http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/
import { Tree, TreeGroup, TreeItem } from '.';
import React from 'react';

const obj = {
  title: 'Tree',
  component: Tree,
  includeStories: [], // or don't load this file at all
};
export default obj;

export const example = () => (
  <Tree>
    <TreeGroup
      id={'g1'}
      level={1}
      position={1}
      setSize={3}
      renderLabel={({ expanded, focused }) =>
        `${expanded ? '⌄' : '›'} G1 ${focused ? '- has focus' : ''}`
      }
    >
      {() => (
        <>
          <TreeGroup
            id={'g1-1'}
            level={2}
            position={1}
            setSize={3}
            renderLabel={({ expanded, focused }) =>
              `${expanded ? '⌄' : '›'} Group G1-1 ${
                focused ? '- has focus' : ''
              }`
            }
          >
            {() => (
              <>
                <TreeItem level={3} position={1} setSize={3}>
                  {({ focused }) =>
                    `Item G1-1 1 ${focused ? '- has focus' : ''}`
                  }
                </TreeItem>
                <TreeItem level={3} position={2} setSize={3}>
                  {({ focused }) =>
                    `Item G1-1 2 ${focused ? '- has focus' : ''}`
                  }
                </TreeItem>
                <TreeItem level={3} position={3} setSize={3}>
                  {({ focused }) =>
                    `Item G1-1 3 ${focused ? '- has focus' : ''}`
                  }
                </TreeItem>
              </>
            )}
          </TreeGroup>
          <TreeItem level={1} position={2} setSize={2}>
            {({ focused }) => `Item G1-2 ${focused ? '- has focus' : ''}`}
          </TreeItem>
        </>
      )}
    </TreeGroup>
    <TreeItem level={1} position={2} setSize={3}>
      {({ focused }) => `Item G2 ${focused ? '- has focus' : ''}`}
    </TreeItem>
    <TreeItem level={1} position={3} setSize={3}>
      {({ focused }) => `Item G3 ${focused ? '- has focus' : ''}`}
    </TreeItem>
  </Tree>
);
